import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import computed from 'ember-computed';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

export default Controller.extend({
  similarChannels: injectService(),
  following: injectController('directory/following'),
  storage: injectService(),

  isLoadingFollowsCount: computed.alias('following.content.isLoading'),
  hasFollows: computed.alias('following.hasFollows'),
  noLiveChannels: computed.empty('model'),

  maxItems: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH,
    rowCount: 2
  }),

  sampleStreams: computed('model.content.[]', 'maxItems', 'hasMoreStreams', function () {
    let maxItems = this.get('maxItems');
    let content = this.get('model.content');

    if (this.get('hasMoreStreams')) {
      /* A placeholder will be shown to expand the list to all channels */
      maxItems--;
    }

    return content.slice(0, maxItems);
  }),

  hasMoreStreams: computed('model.length', 'maxItems', function () {
    let modelCount = this.get('model.length');
    let maxItems = this.get('maxItems');
    return modelCount > maxItems;
  }),

  actions: {
    loadMoreStreams: function () {
      if (this.get('model')) {
        this.get('model').loadMore();
      }
    }
  }
});
