import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import computed from 'ember-computed';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { GAME_BOX_MIN_WIDTH } from 'web-client/services/layout';

export default Controller.extend({
  similarChannels: injectService(),
  storage: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  allFollowing: computed(function() {
    return DeprecatedGameModel.find('allFollows').load();
  }),

  isLoadingGames: computed.and('model.isLoading', 'allFollowing.isLoading'),
  isLoadingGameFollowsCount: computed.and('content.isLoading', 'allFollowing.isLoading'),
  hasGameFollows: computed.not('allFollowing.isFollowless'),
  hasLiveGames: computed.gt('model.length', 0),

  maxItems: limitForDirectoryTower({ minWidth: GAME_BOX_MIN_WIDTH }),

  sampleGames: computed('model.sortedContent.[]', 'maxItems', 'hasMoreGames', function () {
    let sortedContent = this.get('model.sortedContent');
    let maxItems = this.get('maxItems');
    if (this.get('hasMoreGames')) {
      /* A placeholder will be shown to expand the list to all games */
      maxItems--;
    }
    return sortedContent.slice(0, maxItems);
  }),

  hasMoreGames: computed('model.length', 'maxItems', function () {
    let modelCount = this.get('model.length');
    let maxItems = this.get('maxItems');
    return modelCount > maxItems;
  }),

  actions: {
    loadMoreGames: function () {
      if (this.get('model')) {
        this.get('model').loadMore();
      }
    }
  }
});
