import Controller from 'ember-controller';
import injectController from 'ember-controller/inject';
import computed from 'ember-computed';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

export default Controller.extend({
  following: injectController('directory/following'),

  isLoadingFollowsCount: computed.alias('following.content.isLoading'),
  hasFollows: computed.alias('following.hasFollows'),
  noHostsLive: computed.empty('model'),

  maxItems: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH,
    rowCount: 2
  }),

  sampleHosts: computed('model.content.[]', 'maxItems', 'hasMoreHosts', function () {
    let maxItems = this.get('maxItems');
    let content = this.get('model.content');

    if (this.get('hasMoreHosts')) {
      // Reserve a spot for "View All" button
      maxItems--;
    }

    return content.slice(0, maxItems);
  }),

  hasMoreHosts: computed('model.length', 'maxItems', function () {
    let modelCount = this.get('model.length');
    let maxItems = this.get('maxItems');
    return modelCount > maxItems;
  }),

  actions: {
    loadMoreHosts: function () {
      if (this.get('model')) {
        this.get('model').loadMore();
      }
    }
  }
});
