import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

export default Controller.extend({
  globals: injectService(),
  showVideoSection: computed.alias('globals.followingVideosEnabled'),
  vodCoviews: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  recsHoldout: injectService('recs-holdout'),

  towerOverride: null,
  maxItems: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH,
    rowCount: 2
  }),
  maxVodsPerRow: computed.readOnly('maxItems'),

  hasMoreVideos: computed('model.length', 'maxItems', function () {
    let modelCount = this.get('model.length');
    let maxItems = this.get('maxItems');
    return modelCount > maxItems;
  }),

  sampleVideos: computed('model.content.[]', 'maxItems', 'hasMoreVideos', function () {
    let maxItems = this.get('maxItems');
    let content = this.get('model.content');

    if (this.get('hasMoreVideos')) {
      /* A placeholder will be shown to expand the list to all videos */
      maxItems--;
    }

    return content.slice(0, maxItems);
  }),

  isLoadingVideos: computed.alias('model.isLoading'),

  hasVideos: computed.alias('model.total'),

  //TODO: this appears to be dead code
  actions: {
    loadMore: function () {
      let model = this.get('model');

      if (model) {
        model.loadMore();
      }
    }
  }
});
