import Controller from 'ember-controller';
import utils from 'web-client/utilities/main';
import computed, { equal } from 'ember-computed';
import injectController from 'ember-controller/inject';
import injectService from 'ember-service/inject';
import { CSGO, IRL } from 'web-client/utilities/game-names';

let GameDirectoryController = Controller.extend({
  clips: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  broadcasterLanguage: injectController('directory/game/broadcaster-language'),
  isCsgo: equal('model.name', CSGO),
  isIRL: equal('model.name', IRL)
});

utils.setOnReady(GameDirectoryController, {
  propertyName: 'languageChannelsCountPromise',

  readyToResolveCondition: computed('broadcasterLanguage.content.total', 'broadcasterLanguage.content.isLoading', function () {
    return this.get('broadcasterLanguage.content.total') !== undefined &&
           !this.get('broadcasterLanguage.content.isLoading');
  }),

  value: function () {
    return this.get('broadcasterLanguage.content.total');
  }
});

export default GameDirectoryController;
