import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import computed from 'ember-computed';

export default Controller.extend({
  layout: injectService(),
  gameChannelsBroadcasterLanguage: injectController('directory/game/broadcaster-language'),
  browse: injectService(),
  languageDirectoryFilter: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  isLolMetadataFilterEnabled: computed('model.game', function () {
    return false;
  }),

  actions: {
    loadMoreStreams: function () {
      let model = this.get('model');

      if (model) {
        model.loadMore();
      }
    }
  }
});
