/* globals _ */

import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import computed from 'ember-computed';

export default Controller.extend({
  featured: computed(function() {
    return DeprecatedGameModel.find('featured').load();
  }),
  layout: injectService(),
  application: injectController(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  gamesSort: ['viewerCount:desc'],
  sortedGames: computed.sort('games', 'gamesSort'),
  isLoading: computed.empty('sortedGames'),

  init() {
    this._super(...arguments);
    this.games = [];
  },

  featuredSidePanel: computed('featured.content', 'featured.isLoading', function () {
    let featuredGames = this.get('featured');

    if (featuredGames.isLoading) {
      return [];
    }

    let sidePanelFeaturedGames = _.first(_.filter(featuredGames.content, function (game) {
      return game.featuredOnSidePanel;
    }), 3);

    return sidePanelFeaturedGames;
  }),

  featuredDirectory: computed('featured.content', 'featured.length', function () {
    let featuredGames = this.get('featured');
    let games = _.filter(featuredGames.content, function (game) {
      return game.featuredOnDirectory;
    });
    let result = (featuredGames.isLoading ? [] : games);

    return result;
  }),

  loadMoreTopGames: function () {
    this.send('loadMoreTopGames');
  }
});
