import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';
import computed from 'ember-computed';

export default Controller.extend({
  languageDirectoryFilter: injectService(),
  vodCoviews: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  maxVodsPerRow: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH
  })
});
