/* globals _ */

import Controller from 'ember-controller';

import Ember from 'ember';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import computed from 'ember-computed';

const { isEmpty, on } = Ember;
const TOP_GAMES_COUNT = 40;

export default Controller.extend({
  queryGames: on('init', function () {
    let games = this.store.peekAll('game');

    if (isEmpty(games)) {
      this.store.query('game', {kind: 'top', limit: TOP_GAMES_COUNT});
    }

    this.set('allGames', games);
  }),

  gameFollows: DeprecatedGameModel.find('allFollows'),

  sampleGames: computed("allGames.@each.viewerCount", function () {
    let games = this.get('allGames').filterBy('viewerCount');
    return _.shuffle(games, 32);
  }),

  canContinue: computed('gameFollows.length', function () {
    return this.get('gameFollows.length') > 0;
  }),

  actions: {
    noop: function() { }
  }
});
