/* globals _ */

import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import computed from 'ember-computed';

export default Controller.extend({
  liveFollowing: computed(function() {
    return DeprecatedGameModel.find('liveFollows').load();
  }),

  allFollowing: computed(function() {
    return DeprecatedGameModel.find('allFollows').load();
  }),

  layout: injectService(),
  application: injectController(),

  total: computed.alias('liveFollowing.total'),
  isLoading: computed.alias('liveFollowing.isLoading'),
  isFollowless: computed.alias('allFollowing.isFollowless'),

  sidePanelFollowing: computed('liveFollowing.[]', function () {
    return _.first(this.get('liveFollowing.sortedContent'), 5);
  })
});
