/* globals URI */

import Controller from 'ember-controller';

import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Controller.extend({
  tracking: injectService(),

  init() {
    this._super(...arguments);
    let queryParams = URI.parseQuery(window.location.search);
    this.get('tracking').trackEvent({
      event: 'subscription_product_landing',
      services: ['mixpanel'],
      data: {
        ref_link: queryParams.ref,
        product_group: "gom"
      }
    });
  },

  regularSeasonSub: computed(function () {
    return `/products/gsl_2015_s1${window.location.search}`;
  }),

  regularYearSub: computed(function () {
    return `/products/gsl_2015_s1${window.location.search}`;
  }),

  premiumSeasonSub: computed(function () {
    return `/products/gsl_2015_s1_premium${window.location.search}`;
  }),

  premiumYearSub: computed(function () {
    return `/products/gsl_2015_s1_premium${window.location.search}`;
  })
});
