import Controller from 'ember-controller';
import RebroadcasterMixin from 'web-client/mixins/rebroadcaster';
import injectController from 'ember-controller/inject';
import injectService from 'ember-service/inject';

export default Controller.extend(RebroadcasterMixin, {
  application: injectController(),
  layout: injectService(),
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService(),
  videoProcessor: injectService(),

  transitionPendingConfirmation: null,
  fileToUpload: null,
  activeUploadsTab: false,

  showSchedulingModal(file) {
    this.set('fileToUpload', file);
  },

  actions: {
    removeVideo(video) {
      this.get('videos').removeObject(video);
    },

    cancelTransition() {
      this.set('transitionPendingConfirmation', null);
    },

    confirmPendingTransition() {
      let transition = this.get('transitionPendingConfirmation');
      transition.data.isConfirmed = true;
      transition.retry().then(() => {
        this.set('transitionPendingConfirmation', null);
      });
    },

    cancelUpload() {
      this.set('fileToUpload', null);
    },

    startUpload(video, file) {
      this.set('fileToUpload', null);
      this.transitionToRoute('manager.uploads');
      this.get('videoProcessor').startVideoUpload(video, file);
    }
  }
});
