/* globals Twitch */

import $ from 'jquery';
import Controller from 'ember-controller';
import YoutubeExporterMixin from 'web-client/mixins/youtube-exporter';
import computed from 'ember-computed';
import computedEqualProperty from 'web-client/utilities/computed-equal-property';
import injectController from 'ember-controller/inject';
import injectService from 'ember-service/inject';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default Controller.extend(YoutubeExporterMixin, {
  application: injectController(),
  manager: injectController(),
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService(),
  api: injectService(),
  tracking: injectService(),

  api_id: null,
  embed_player: null,
  firstPage: true,
  highlightCreated: null,
  isCreatingHighlight: null,
  permalink: null,
  playerComponent: null,
  video: computed.alias('model'), // Required by youtube mixin

  isVodOwner: computedEqualProperty('model.channel.name', 'login.userData.login'),

  showYoutubeExport: computed('model.youtube_exporting_disabled', function() {
    if (this.get('manager.model.id') === this.get('login.userData.login')) {
      return true;
    }
    return !this.get('model.youtube_exporting_disabled');
  }),

  twitterShare: computed('model.title', 'model.highlight_title', function () {
    return `Watch ${this.get('model.highlight_title')} on @Twitch`;
  }),

  twitterTextLink: computed('permalink', function() {
    let base = 'https://twitter.com/intent/tweet?';
    let text = `text=${this.get('twitterShare')} ${this.get('permalink')}`;

    return base + text;
  }),

  playerVideoId: computed('model.id', function() {
    return `v${normalizeVideoId(this.get('model.id'))}`;
  }),

  resetState() {
    this.setProperties({
      firstPage: true,
      isCreatingHighlight: false,
      highlightCreated: false
    });
  },

  actions: {
    next() {
      this.set('firstPage', false);
    },

    previous() {
      this.set('firstPage', true);
    },

    setPlayerComponent(playerComponent) {
      this.set('playerComponent', playerComponent);
    },

    createHighlight() {
      let url = `/kraken/videos/${normalizeVideoId(this.get('model.id'))}/highlight`;

      this.set('isCreatingHighlight', true);

      this.get('tracking').trackEvent({
        event: 'highlighter-create-click',
        services: ['mixpanel']
      });
      this.get('api').authRequest('post', url, $('.js-highlighter-form').serialize(), {version: 5}).then((response) => {
        if (this.isDestroyed) { return; }
        this.set('highlightCreated', true);
        this.set('permalink', response.url);
        this.set('embed_player', response.embed_player);
        this.set('api_id', response.api_id);
      }, (response) => {
        Twitch.notify.error(JSON.parse(response.responseText).message);
      }).finally(() => {
        if (this.isDestroyed) { return; }
        this.set('isCreatingHighlight', false);
      });
    }
  }
});
