/* globals i18n */

import Controller from 'ember-controller';
import Ember from 'ember';
import computed from 'ember-computed';
import SendRouteAction from 'web-client/mixins/send-route-action';

const { inject } = Ember;

export default Controller.extend(SendRouteAction, {
  application: inject.controller(),

  viewByHeader: computed('application.currentRouteName', function () {
    let currentRouteName = this.get('application.currentRouteName');
    if (currentRouteName === 'manager.past-broadcasts.all') {
      return i18n('All Broadcasts');
    }
    return i18n('Expiring');
  })
});
