/* globals SiteOptions */
import Ember from 'ember';
const { LinkComponent } = Ember;

export default LinkComponent.reopen({
  attributeBindings: [
    'data-test-selector',
    'data-channel-link',
    'data-ts_selectable',
    'data-tt_content_index',
    'data-tt_content',
    'data-tt_medium',
    'data-id',
    'data-login',
    'data-position',
    'role'
  ]
});

if (SiteOptions.embedEmberComponents) {
  // When embedding components we need to make sure that any link-to components
  // perform a full refresh when clicked.
  LinkComponent.reopen({
    // Disable normal path that uses LinkComponent._invoke()
    eventName: '__no-event__',

    // Add our own click handler that lets links work normally.
    click() {
      window.location = this.element.href;
    }
  });
}
