import Helper from 'ember-helper';
import injectService from 'ember-service/inject';

export default Helper.extend({
  bitsAdsEnabled: injectService(),

  init() {
    this._super(...arguments);
    this._value = null;
  },

  compute([channelName]) {
    if (this._value !== null) {
      return this._value;
    }

    this.get('bitsAdsEnabled').isEnabled(channelName).then((isEnabled) => {
      this._value = isEnabled;
      this.recompute();
    });

    return false;
  }
});
