import Helper from 'ember-helper';
import observer from 'ember-metal/observer';
import injectService from 'ember-service/inject';
import { typeOf } from 'ember-utils';
import { stringFormat, processStyling } from 'web-client/helpers/styled-i18n';
import { htmlSafe } from 'ember-string';

export const ASYNC_ERRORS = {
  insufficient_balance: 'You do not have enough Bits in your inventory. Please purchase more Bits.',
  message_length_exceeded: 'Please keep your message under 500 characters to Cheer.',
  invalid_bits_amount: 'Bits amount must equal message amount',
  invalid_bits_message: 'Message must contain "cheer" and a number greater than 0.',
  user_ineligible: 'You are currently unable to Cheer. Please contact customer support at twitch.tv/support for more information.',
  user_banned: 'You cannot Cheer while banned or timed out.',
  channel_ineligible: 'This channel does not support Cheering.',
  bits_emote_too_large: '10000 is the largest Cheer emote, add another emote to Cheer louder!',
  below_min_bits: 'You must use more bits to Cheer in this channel.'
};

export default Helper.extend({
  bitsStrings: injectService(),

  onLoaded: observer('bitsStrings.isLoaded', function () {
    this.recompute();
  }),

  compute([key, defaultString = '', ...args]) {
    let bitsStringsSvc = this.get('bitsStrings');

    if (!bitsStringsSvc.isLoaded) {
      return defaultString;
    }

    let values;
    if (args && args[0] && typeOf(args[0]) === 'object') {
      values = args[0];
    } else {
      values = args;
    }

    let translatedString = bitsStringsSvc.getString(key, defaultString);
    translatedString = processStyling(translatedString);
    translatedString = stringFormat(translatedString, values);

    return htmlSafe(translatedString);
  }
});
