import Ember from 'ember';
import { helper } from 'ember-helper';
import { htmlSafe } from 'ember-string';
import formatNumber from 'web-client/utilities/format-number';

const { Handlebars: { Utils: { escapeExpression } } } = Ember;

export function commatized(value) {
  let commatizedValue = formatNumber(value, { separator: ',' }),
      escaped = escapeExpression(commatizedValue);
  return escaped;
}

export default helper(function ([ value ]) {
  return htmlSafe(commatized(value));
});
