import Helper from 'ember-helper';
import withMomentTimezoneData from 'web-client/utilities/with-moment-timezone-data';

export default Helper.extend({
  tz: null,

  compute(_args, { format }) {
    if (this.tz) {
      return this.tz(this.tz.guess()).format(format);
    }

    withMomentTimezoneData().then(tz => {
      this.tz = tz;
      this.recompute();
    });

    return '';
  }
});
