import Helper from 'ember-helper';
import injectService from 'ember-service/inject';

export default Helper.extend({
  tracking: injectService(),

  compute([action]) {
    return (event) => {
      this.get('tracking').handleCampaignClick(event);

      // Allow links to open in a new tab with control key, command key, or middle click
      if (event && !event.ctrlKey && !event.metaKey && event.button !== 1) {
        event.preventDefault();
      }

      event.stopPropagation();
      return action(event);
    };
  }
});
