import Helper from 'ember-helper';

export function filterEmotes(params, {filter}) {
  filter = filter.toLowerCase();
  return params.reduce((filteredEmotes, emotes) => (
    filteredEmotes.concat(emotes.filter(emote => emoteMatchesFilter(emote, filter)))
  ), []);
}

export function emoteMatchesFilter(emote, filter) {
  let {regex, code} = emote;
  if (regex && (new RegExp(regex, 'i')).test(filter)) {
    return true;
  }
  return (code || regex || '').toString().toLowerCase().indexOf(filter) !== -1;
}

export default Helper.helper(filterEmotes);
