import { helper } from 'ember-helper';

/*
  Simple helper that takes a dollar amount and only returns the cents portion,
  the decimal is no included in the return.
*/

export function floatToCents(revenue) {
  let revenueString = parseFloat(revenue).toFixed(2).toString();
  let decimal = revenueString.indexOf('.');
  let cents = revenueString.substring(decimal + 1);

  return cents.length < 2 ? `${ cents }0` : cents;
}

export default helper(floatToCents);
