import { helper } from 'ember-helper';
import { styledI18n } from 'web-client/helpers/styled-i18n';
import { htmlSafe } from 'ember-string';

/*
  Simple helper to split a translated string using the "|" character.
  Should be used to handle DOM elements within translated strings.

  Supports string substitution via the styled-i18n helper.

  Usage leverages the at-index helper.

  Suppose we have the string "green |salsa|!" which would be translated to "|salsa| verde!".

    {{#with (i18n-split-string "green |salsa|!") as |translated|}}
      {{at-index translated 0}}<a href="#salsa">{{at-index translated 1}}</a>{{at-index translated 2}}
    {{/with}}

  Becomes

    <a href="#salsa">salsa</a> verde!

*/

export function i18nSplitString([string, ...args]) {
  // styledI18n returns an htmlSafeString, we just need the underlying string
  let i18nText = styledI18n(string, args).string;
  return i18nText.split('|').map((s) => {return htmlSafe(s);});
}

export default helper(i18nSplitString);
