/* globals Twitch */

import Ember from 'ember';
import { helper } from 'ember-helper';
import { htmlSafe } from 'ember-string';

const { Handlebars: { Utils: { escapeExpression } } } = Ember;

export default helper(function ([ value ]) {
  let lengthAsClock = Twitch.display.lengthAsClock(value);
  let escaped = escapeExpression(lengthAsClock);
  return htmlSafe(escaped);
});
