/* globals i18n */
import { helper } from 'ember-helper';
import moment from 'moment';

export default helper(function ([date]) {
  // handle clock skew
  let now = moment();
  let mdate = moment.min(moment(date), now);

  let diff = now.diff(mdate, 'seconds');
  if (diff > 5 && diff < 60) {
    return i18n('{seconds} seconds ago').replace('{seconds}', diff);
  }

  return mdate.fromNow();
});
