import { helper } from 'ember-helper';

export default helper(function([numerator, denominator]) {
  if (typeof numerator !== 'number' || typeof denominator !== 'number') {
    return '';
  }

  if (denominator === 0) {
    return '0%';
  }

  return `${Math.floor(numerator / denominator * 100)}%`;
});
