import Helper from 'ember-helper';
import injectService from 'ember-service/inject';

/**
 * Create a URL from a given route/model
 *
 * Example:
 * <pre>
 * 	<a href={{route-for 'directory.game' game}}>
 *
 *	Relative URL (default): {{route-for 'vod' 'video.channelName' 'video.id'}}
 *	          Absolute URL: {{route-for 'vod' 'video.channelName' 'video.id' absolute=true}}
 * </pre>
 */
export default Helper.extend({
  /**
   * This is a private Ember API undergoing RFC design before being made public.
   * It should be refactored to public API when that service lands.
   */
  routing: injectService('-routing'),

  compute([routeName, ...models], hash = {}) {
    let router = this.get('routing');
    let prefix = hash.absolute ? location.origin : '';
    let relativeUrl = router.generateURL(routeName, models, {});

    return `${prefix}${relativeUrl}`;
  }
});
