import { helper } from 'ember-helper';

/*
 * When using the tower styles, it can be desireable to add placeholders to
 * ensure cell widths remain constant for a final row of the grid. This
 * helper generates 10 placeholders with the proper class name.
 *
 * See:
 *
 *   * https://git-aws.internal.justin.tv/pages/web/styles/tower.html
 *   * https://git-aws.internal.justin.tv/web/styles/releases/tag/v0.15.0
 *
 */
export function towerPlaceholder() {
  let fragment = document.createDocumentFragment();

  for (let i = 0; i < 10; i++) {
    let element = document.createElement('div');
    element.className = 'tower_placeholder';
    fragment.appendChild(element);
  }

  return fragment;
}

export default helper(towerPlaceholder);
