import { helper } from 'ember-helper';
import { htmlSafe } from 'ember-string';

/*
  Simple helper to mark unsafe attributes as trusted by the developer.

  Allows you to avoid using triple curly braces without context while also
  silencing any warnings about unsafe attributes.

  Please try to avoid using this.
*/

export function trustedUnsafeAttribute(attribute) {
  return htmlSafe(attribute);
}

export default helper(trustedUnsafeAttribute);
