import { helper } from 'ember-helper';

export const TIMESTAMP_INTERVAL = 600000;

export default helper(function ([messages, message]) {
  let messageIndex = messages.indexOf(message);
  let isFirstMessage = messageIndex === 0;
  if (isFirstMessage) {
    return true;
  }

  let prevMessage = messages[messageIndex - 1];
  let timeSincePreviousMessage = message.get('sentAt') - prevMessage.get('sentAt');

  if (timeSincePreviousMessage > TIMESTAMP_INTERVAL) {
    return true;
  }

  return false;
});
