import { helper } from 'ember-helper';

/*
  Simple helper to that takes a dollar amount (integer) and converts it to USD currency format.

  If the dollar amount or a max value is greater than 10, then the fraction digits are stripped.

  Examples:

    `{{usd-currency 19231.27}}` becomes $19,231.
    `{{usd-currency 7.27}}` becomes $7.27.

*/

export function USDCurrency(value, max) {
  let maxDigitsComparator = max || value;
  let digits = (maxDigitsComparator <= 10) ? 2 : 0;

  return `$${ Number(value).toFixed(digits).replace(/\B(?=(\d{3})+(?!\d))/g, ',') }`;
}

export default helper(function ([ value, max ]) {
  return USDCurrency(value, max);
});
