import { helper } from 'ember-helper';
import {
  SORT_VIEWS_TYPE,
  SORT_TIME_TYPE
} from 'web-client/utilities/video/sorts';

const SORT_LABEL_MAP = {
  [SORT_VIEWS_TYPE]: 'Popular',
  [SORT_TIME_TYPE]: 'Recent'
};

export function videoSortLabel(videoSort) {
  if (!videoSort) {
    return '';
  }
  return SORT_LABEL_MAP[videoSort];
}

export default helper(function([ videoSort ]) {
  return videoSortLabel(videoSort);
});
