import { helper } from 'ember-helper';
import { ALL_VIDEOS_TYPE } from 'web-client/mixins/video-type';

export function videoTypeLabel([ videoType ]) {
  if (!videoType) {
    return '';
  }

  if (videoType === ALL_VIDEOS_TYPE) {
    return 'All Videos';
  }

  let words = videoType.split('-');
  let capitalized = words.map((word) => word.capitalize());

  return capitalized.join(' ');
}

export default helper(videoTypeLabel);
