import Ember from 'ember';
import config from 'web-client/config/environment';

const { getWithDefault } = Ember;

export function initialize(appInstance) {
  let intl = appInstance.lookup('service:intl');
  let fullLocale = getWithDefault(window, 'i18nLocale.full', config.i18n.baseLocale);

  let locales = [fullLocale];
  if (fullLocale !== config.i18n.baseLocale) {
    locales.push(config.i18n.baseLocale);
  } 
  intl.setLocale(locales);

  if (typeof window['getTranslations'] === 'function') {
    let translations = window.getTranslations();
    Object.keys(translations).forEach((locale) => {
      intl.addTranslations(locale, translations[locale]);
    });
  }

  // This Mixpanel event is temporary to monitor roll out
  appInstance.register('util:intl/missing-message', function (key) {
    appInstance.lookup('service:tracking').trackEvent({
      services: ['mixpanel'],
      event: 'client_intl_i18n_missing',
      data: {
        key: key
      }
    });

    return key;
  });
}

export default {
  name: 'intl-i18n',
  initialize
};
