import { setOwnerInjection } from 'web-client/utilities/owner-injection';

/*
 * `ownerInjection()` returns an object with the symbol and owner
 * object for the application controller, which when passed to
 * `create` for a new factory will make its instance compatible with
 * `Ember.inject.service`.
 */
export default {
  name: 'legacy-owner-injection',
  initialize(appInstance) {
    setOwnerInjection(appInstance.ownerInjection());
  }
};
