import Mixin from 'ember-metal/mixin';
import { assert } from 'ember-metal/utils';

export default Mixin.create({

  init() {
    this._super(...arguments);
    assert(`Component ${this} must implement "clickedOutside".`, !!this.clickedOutside);
  },

  didInsertElement() {
    this._super(...arguments);
    this.addEventListener(document.body, 'click', (e) => {
      if (this.$().has(e.target).length === 0) {
        this.clickedOutside();
      }
    });
  }

});
