/* globals i18n */

import Mixin from 'ember-metal/mixin';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import { formatDisplayName } from 'web-client/helpers/format-display-name';

const TRANSLATED_BAN_CONFIRM = i18n('Are you sure you want to ban {{name}}?');
const TRANSLATED_TIMEOUT_CONFRIM = i18n('Are you sure you want to timeout {{name}}?');

export default Mixin.create(SendRouteActionMixin, {
  communities: injectService(),

  reason: '',
  timeoutDuration: 2,

  shouldDisableButton: computed('reason', 'timeoutDuration', function() {
    return this.get('reason.length') === 0 ||
      this.get('timeoutDuration') === null;
  }),

  banConfirmString: computed('userDisplayName', 'userLogin', function() {
    let name = this.get('userLogin');
    if (this.get('userDisplayName')) {
      name = formatDisplayName(this.get('userLogin'), this.get('userDisplayName'), true);
    }
    return TRANSLATED_BAN_CONFIRM.replace('{{name}}', name);
  }),

  timeoutConfirmString: computed('userDisplayName', 'userLogin', function() {
    let name = this.get('userLogin');
    if (this.get('userDisplayName')) {
      name = formatDisplayName(this.get('userLogin'), this.get('userDisplayName'), true);
    }
    return TRANSLATED_TIMEOUT_CONFRIM.replace('{{name}}', name);
  }),

  init() {
    this._super(...arguments);
    let timeoutDurations = [];
    timeoutDurations[0] = { value: 2, text: i18n('{{num}} hours').replace('{{num}}', 2) };
    timeoutDurations[1] = { value: 4, text: i18n('{{num}} hours').replace('{{num}}', 4) };
    timeoutDurations[2] = { value: 8, text: i18n('{{num}} hours').replace('{{num}}', 8) };
    timeoutDurations[3] = { value: 12, text: i18n('{{num}} hours').replace('{{num}}', 12) };
    timeoutDurations[4] = { value: 24, text: i18n('{{num}} hours').replace('{{num}}', 24) };
    this.set('timeoutDurations', timeoutDurations);
  },

  actions: {
    banUser() {
      let userId = this.get('userId');
      this.get('communities').banUser(userId, this.get('reason')).then(() => {
        if (this.isDestroyed) { return; }
        if (this.banUserCallback) {
          this.banUserCallback();
        }
        this.sendRouteAction('closeModal');
      });

    },

    timeoutUser() {
      let userId = this.get('userId');
      let duration = parseInt(this.get('timeoutDuration'), 10);
      let timeoutParams = {
        reason: this.get('reason'),
        duration_hours: duration
      };

      this.get('communities').timeoutUser(userId, timeoutParams).then(() => {
        if (this.isDestroyed) { return; }
        if (this.timeoutUserCallback) {
          this.timeoutUserCallback(duration);
        }
        this.sendRouteAction('closeModal');
      });
    },

    selectTimeoutDuration(value) {
      this.set('timeoutDuration', value);
    },

    openInModal(type) {
      if (!['ban', 'timeout'].includes(type)) {
        return;
      }
      this.sendRouteAction('openInModal', `communities/${type}User`, this);
    },

    closeModal() {
      this.sendRouteAction('closeModal', ...arguments);
    }
  }
});
