import Mixin from 'ember-metal/mixin';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import { CREATIVE, CREATIVE_GAME_COMMUNITY_MAPPING } from 'web-client/utilities/game-names';

export default Mixin.create({
  store: injectService(),
  api: injectService(),

  communities: computed('contentGame', 'store', function () {
    let game = this.get('contentGame');
    return this.get('store').query('community', { game, limit: 100 });
  }),

  supportsCommunities: computed.bool('communities.length'),

  actions: {
    didOpen() {
      return;
    },

    onGameChange(id) {
      if (CREATIVE_GAME_COMMUNITY_MAPPING.hasOwnProperty(id)) {
        let community = CREATIVE_GAME_COMMUNITY_MAPPING[id];
        this.set('contentTitle', `${this.get('contentTitle')} ${community}`);
        this.set('contentGame', CREATIVE);
      }
    }
  }
});
