import Mixin from 'ember-metal/mixin';

export default Mixin.create({

  _expiration: 300000, // default expiration is 5 minutes

  setExpirationInterval(milliseconds) {
    this.set('_expiration', milliseconds);
  },

  justGotData() {
    this.set('_lastUpdateTime', new Date().getTime());
  },

  isExpired() {
    if (!this.get('_expiration')) {
      return false;
    }
    return new Date().getTime() - (this.get('_lastUpdateTime') || 0) > this.get('_expiration');
  }

});
