import Mixin from 'ember-metal/mixin';
import injectService from 'ember-service/inject';
import { assign } from 'ember-platform';

export default Mixin.create({
  tracking: injectService(),

  _createEvent(eventType, data) {
    let trackingData = this._baseTrackingData();
    assign(trackingData, data);
    return {
      event: eventType,
      data: trackingData
    };
  },

  _baseTrackingData() {
    let pageviewProperties = this.get('tracking.funnel.pageviewProperties') || {};
    return {
      benchmark_session_id: this.get('tracking.benchmark').getSession(),
      page_session_id: pageviewProperties.page_session_id,
      tab_session_id: pageviewProperties.tab_session_id
    };
  },

  trackEvent(eventType, data = {}) {
    this.get('tracking').trackEvent(this._createEvent(eventType, data));
  }
});
