import Mixin from 'ember-metal/mixin';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import on from 'ember-evented/on';

/**
 * For components that should inform the interactivity service
 * that they are now ready for user interaction.
 *
 * In your component, you MUST call this.reportInteractive().
 */
export default Mixin.create({
  interactivity: injectService(),

  /**
   * Builds an id from the component name based on its `toString` property
   * Ex: <web-client@component:channel-redesign/top-bar::ember2046>
   * Returns 'channel-redesign/top-bar'
   *
   * WARNING: These ids are not unique (but should be), because the subscribers in the
   * `interactivity` service have no way to track unique components at this time
   */
  latencyReportingId: computed(function () {
    return this.toString().split(':')[1];
  }),

  /**
   * Call this method when the component has determined it is rendered/interactive
   *
   * Example:
   * defaultInteractivity: on('didInsertElement', function () {
   *   scheduleOnce('afterRender', this, this.reportInteractive);
   * })
   *
   * @method reportInteractive
   */
  reportInteractive() {
    this.get('interactivity').reportInteractive(this.get('latencyReportingId'));
  },

  /**
   * Call this method when the component has determined it is no longer interactive
   * Executes by default during component teardown
   *
   * @method reportNonInteractive
   */
  reportNonInteractive: on('willDestroyElement', function () {
    this.get('interactivity').reportNonInteractive(this.get('latencyReportingId'));
  })
});
