/* globals Twitch */
import Mixin from 'ember-metal/mixin';
import injectService from 'ember-service/inject';

// Tracking mixin for onsite notifications
export default Mixin.create({
  tracking: injectService(),
  session: injectService(),

  trackNotificationCenterInteraction(action, unseenViewCount)  {
    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    this.get('tracking').trackEvent({
      services: ['spade'],
      event: 'notification_center_interaction',
      data: {
        action: action,
        login: this.get('session.userData.login'),
        user_id: this.get('session.userData.id'),
        unseen_view_count: unseenViewCount,
        platform: 'web',
        location: pageviewProperties.location
      }
    });
  },

  trackNotificationInteraction(action, uiContext, notification, url = '')  {
    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    this.get('tracking').trackEvent({
      services: ['spade'],
      event: 'notification_interaction',
      data: {
        action: action,
        ui_context: uiContext,
        login: this.get('session.userData.login'),
        user_id: this.get('session.userData.id'),
        notification_id: notification.get('id'),
        notification_type: notification.get('type'),
        platform: 'web',
        location: pageviewProperties.location,
        target_url: url
      }
    });
  },

  trackNotificationImpression(uiContext, notification) {
    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    this.get('tracking').trackEvent({
      services: ['spade'],
      event: 'notification_impression',
      data: {
        ui_context: uiContext,
        login: this.get('session.userData.login'),
        user_id: this.get('session.userData.id'),
        notification_id: notification.get('id'),
        notification_type: notification.get('type'),
        location: pageviewProperties.location,
        platform: 'web'
      }
    });
  }
});
