/* globals Twitch */
import Mixin from 'ember-metal/mixin';
import TicketModel from 'web-client/models/ticket';
import computed from 'ember-computed';

export default Mixin.create({
  isChannelOwner: computed('content.id', function () {
    return Twitch.user.login() === this.get('content.id');
  }),

  isSubscribed: computed('content.isSubscribed.isSubscribed', 'content.isSubscribed.isLoading', 'content.id', function () {
    if (typeof this.get('content.isSubscribed.isSubscribed') === 'undefined' && Twitch.user.isLoggedIn()) {
      this.set('content.isSubscribed', TicketModel.find('user', {channel: this.get('content.id')}));
      if (!this.get('content.isSubscribed.isLoaded')) {
        this.get('content.isSubscribed').load();
      }
    }
    if (this.get('content.isSubscribed.isLoading')) {
      return undefined;
    }
    return !!this.get('content.isSubscribed.isSubscribed');
  }),

  showAds: computed('isChannelOwner', 'turboToken', 'isSubscribed', 'content.prerolls', function () {
    let isOwner = this.get('isChannelOwner'),
        isTurbo = !!this.get('turboToken'),
        isSub   = this.get('isSubscribed');

    return !(isOwner || isTurbo || isSub || !this.get('content.prerolls'));
  }),

  turboToken: computed('login.isLoading', 'login.userData.has_turbo', function () {
    if (this.get('login.isLoading')) {
      return undefined;
    }
    return this.get('login.userData.has_turbo') || "";
  }),

  isLeftColumnClosed: computed('layout.isLeftColumnClosed', function () {
    return this.get('layout.isLeftColumnClosed');
  }),

  isRightColumnClosed: computed('layout.isRightColumnClosed', function () {
    return this.get('layout.isRightColumnClosed');
  })
});
