/* globals Twitch */
import Mixin from 'ember-metal/mixin';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default Mixin.create({
  api: injectService(),

  rebroadcastList: [],

  showRebroadcastPanel: computed('rebroadcastList.[]', function () {
    return !!this.get('rebroadcastList').length;
  }),

  actions: {
    addToRebroadcastList(video) {
      this.get('rebroadcastList').pushObject(video);
    },

    removeFromRebroadcastList(video) {
      this.get('rebroadcastList').removeObject(video);
    },

    startRebroadcast() {
      let videoIds = this.get('rebroadcastList').map((video) => normalizeVideoId(video.id));
      this.get('api').request('post', `/api/channels/${this.get('model._id')}/vods/rebroadcast`, {
        vod_ids: videoIds
      });
      Twitch.notify.success(`Please, be patient! The Rebroadcast will take up to ${this.get('rebroadcastList').length * 4} minutes to start.`);
      this.get('rebroadcastList').clear();
    },

    hideRebroadcastPanel() {
      this.get('rebroadcastList').clear();
    }
  }
});
