import Mixin from 'ember-metal/mixin';
import on from 'ember-evented/on';
import injectService from 'ember-service/inject';

export default Mixin.create({
  timer: injectService(),

  startTimer: on('activate', function () {
    let timer = this.get('timer');

    timer.on('timesUp', this, this._timesUp);
    timer.start();
  }),

  stopTimer: on('deactivate', function () {
    let timer = this.get('timer');

    timer.stop();
    timer.off('timesUp', this.timesUp);
  })
});
