/* globals BetterTTV */

import Mixin from 'ember-metal/mixin';
import on from 'ember-evented/on';
import config from 'web-client/config/environment';
import ContextBoundTasksMixin from 'web-client/mixins/context-bound-tasks';
import injectService from 'ember-service/inject';

/*
  Mixin for routes on pages that need to have BTTV tracked.
  If this ends up being used in many more places,
  consider adding this code to tracking-router.js to track BTTV everywhere.

  This event can't be tracked in the pageview event
  as BTTV is not guaranteed to be initialized by the time the route transitions.
*/

export default Mixin.create(ContextBoundTasksMixin, {
  tracking: injectService(),
  trackBttv: on('activate', function () {
    this.runTask(() => {
      this.get('tracking').trackEvent({
        event: 'bttv_check',
        data: {is_bttv: typeof BetterTTV === "object"}
      });
    }, config.delay.bttv.init);
  })
});
