/* globals Twitch */

import Mixin from 'ember-metal/mixin';
import injectService from 'ember-service/inject';

export default Mixin.create({
  vodCoviews: injectService(),
  tracking: injectService(),

  _buildCoviewRecommendationTrackingObj() {
    let recList = this.get('vodCoviews.recommendedVods');
    let uniqueGamesTotal = {};
    let uniqueChannelsTotal = {};
    let uniqueGamesTop8 = {};
    let uniqueChannelsTop8 = {};
    let uniqueGamesViewable = {};
    let uniqueChannelsViewable = {};

    recList.forEach((rec, index) => {
      uniqueGamesTotal[rec.game] = true;
      uniqueChannelsTotal[rec.channel.name] = true;

      if (index < 8) {
        uniqueGamesTop8[rec.game] = true;
        uniqueChannelsTop8[rec.channel.name] = true;
      }
      if (index < this.get('numRecsViewable')) {
        uniqueGamesViewable[rec.game] = true;
        uniqueChannelsViewable[rec.channel.name] = true;
      }
    });

    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    let trackingInfo = {
      rec_set_id: pageviewProperties.page_session_id,
      rec_list: recList.map(vod => {return vod.id;}).join(','),
      had_recs: this.get('vodCoviews.hadRecs'),
      num_recs_made: this.get('vodCoviews.recommendedVods.length'),
      num_recs_viewable: this.get('numRecsViewable'),
      num_recs_api: this.get('vodCoviews.vods.length'),
      num_recs_watched: this.get('vodCoviews.numRecsWatched'),
      num_recs_prefiltered: this.get('vodCoviews.numRecsPrefiltered'),
      forced_variety_max_channels_boundary: this.get('vodCoviews.forcedVarietyMaxChannelsBoundary'),
      unique_games_total: Object.keys(uniqueGamesTotal).length,
      unique_channels_total: Object.keys(uniqueChannelsTotal).length,
      unique_games_top_8: Object.keys(uniqueGamesTop8).length,
      unique_channels_top_8: Object.keys(uniqueChannelsTop8).length,
      unique_games_viewable: Object.keys(uniqueGamesViewable).length,
      unique_channels_viewable: Object.keys(uniqueChannelsViewable).length
    };
    return trackingInfo;
  },

   _buildRemoveRecommendationTrackingObj(vod, position, reason, text) {
    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    let trackingInfo = {
      rec_set_id: pageviewProperties.page_session_id,
      vod_id: vod.id,
      position: position,
      channel: vod.channel.name,
      game: vod.game,
      num_recs_viewable: this.get('numRecsViewable'),
      reason: reason,
      text: text
    };
    return trackingInfo;
  },

  // this event is handled in route/application file, so we shouldn't have `numRecsViewable` implemented here
  _buildClickObject(vod, position, total) {
    let pageviewProperties = Twitch.tracking.funnel.pageviewProperties || {};
    let trackingInfo = {
      game: vod.game,
      channel: vod.channel.name,
      rank_position: position,
      vod_id: vod.id,
      rec_set_id: pageviewProperties.page_session_id,
      num_recs_rendered: total
    };
    return trackingInfo;
  },

  trackSubmitFeedback(vod, position, reason, text) {
    let trackingInfo = this._buildRemoveRecommendationTrackingObj(vod, position, reason, text);
    this.get('tracking').trackEvent({
      event: 'coview_submit_feedback',
      data: trackingInfo
    });
  },

  trackDismiss(vod, position) {
    let trackingInfo = this._buildRemoveRecommendationTrackingObj(vod, position);
    this.get('tracking').trackEvent({
      event: 'coview_remove_rec',
      data: trackingInfo
    });
  },

  trackUndo(vod, position) {
    let trackingInfo = this._buildRemoveRecommendationTrackingObj(vod, position);
    this.get('tracking').trackEvent({
      event: 'coview_remove_rec_undo',
      data: trackingInfo
    });
  },

  trackCoviewRecommendation() {
    let trackingInfo = this._buildCoviewRecommendationTrackingObj();
    this.get('tracking').trackEvent({
      event: 'coview_recommendation',
      data: trackingInfo
    });
  },

  trackCoviewClick(vod, index, total) {
    let trackingInfo = this._buildClickObject(vod, index, total);
    this.get('tracking').trackEvent({
      event: 'coview_recommendation_click',
      data: trackingInfo
    });
  }
});
