/* globals onPopoutClose, Twitch, i18n */
import Mixin from 'ember-metal/mixin';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import $ from 'jquery';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import ContextBoundTasksMixin from 'web-client/mixins/context-bound-tasks';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default Mixin.create(SendRouteActionMixin, ContextBoundTasksMixin, {
  globals: injectService(),
  api: injectService(),
  exportTitle: null,
  exportDescription: null,

  isYoutubeExportingDisabled: computed.alias('globals.disableYoutubeExporter'),

  showSplitVideoCheckbox: computed('video.id', 'video.length', function () {
    return this.get('video.length') > 900;
  }),

  exportUrl: computed('video.id', 'video.channelName', 'api_id', function () {
    let apiID = this.get('api_id') ? this.get('api_id') : this.get('video.id');
    return `videos/${normalizeVideoId(apiID)}/youtube_export`;
  }),

  authenticateWithYoutube() {
    const apiURL = `${Twitch.api.config.baseUrl}/v5/youtube/${this.get('video.channel._id')}/auth?client_id=${Twitch.api.config.clientID}`;

    onPopoutClose(
      window.open(apiURL, 'youtube_popup', 'width=800,height=450'),
      (success) => {
        if (success) {
          this.exportOverlay();
        } else {
          Twitch.notify.error(i18n("You must authenticate with Google in order to upload videos"));
        }
      }
    );
  },

  exportOverlay() {
    this.sendRouteAction("openInModal", "shared/youtube_exporter", this);
    this.runTask(() => {
      let $form = $("#upload_form_container form");

      $form.find("input[name=title]").val(this.get('exportTitle'));
      $form.find("textarea[name=description]").val(this.get('exportDescription'));
      $form.find("input[name=tag_list]").val(this.get('video.tag_list'));
    });
  },

  exportVod() {
    if (this.get("video.youtubeConnected")) {
      this.exportOverlay();
    } else if (this.get('isVodOwner')) {
      this.authenticateWithYoutube();
    } else {
      Twitch.notify.error(i18n("This channel has not connected their youtube account"));
    }
  },

  actions: {
    handleExport() {
      this.set('exportTitle', this.get('video.title'));
      this.set('exportDescription', this.get('video.description'));
      this.exportVod();
    },

    handleHighlighterExport() {
      this.set('exportTitle', this.get('model.highlight_title'));
      this.set('exportDescription', this.get('model.highlight_description'));
      this.exportVod();
    },

    uploadVideo() {
      this.sendRouteAction('closeModal');
      this.get('api').request('post', this.get('exportUrl'), $("#upload_form_container form").serialize(), {version: 5})
      .then(() => {
        if (this.isDestroyed) { return; }
        let msg = i18n('Your video is being uploaded. You will get an email when the upload finishes.');
        Twitch.notify.success(msg);
      }, () => {
        Twitch.notify.error(i18n('There was an error processing your upload.'));
      });
    }
  }
});
