/* globals _ */

import Ember from 'ember';
import StoreModel from 'web-client/models/store';

const { inject } = Ember;

const BadgeSetModel = StoreModel.defineModel({
  api: inject.service(),

  request() {
    return this.get('api').request('get', `chat/${this.get('id')}/badges`);
  },

  afterSuccess(response) {
    if (response) {
      BadgeSetModel.create(_.defaults({
        id: this.get('id')
      }, response));
    }
  }
});

export default BadgeSetModel;
