/* globals  _  */

import Ember from 'ember';
import StoreModel from 'web-client/models/store';

const { inject } = Ember;

const ChannelViewer = StoreModel.defineModel({
  api: inject.service(),
  expiration: 60000, // 1 minute

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('id')}/viewer`);
  },

  afterSuccess(response) {
    if (response) {
      ChannelViewer.create(_.defaults({
        id: this.get('id')
      }, response));
    }
  }
});

export default ChannelViewer;
